/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles.companion;

import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.entity.EntityNPCInterface;

public class CompanionFoodStats {
    private float foodExhaustionLevel;
    private int foodLevel = 20;
    private float foodSaturationLevel = 5.0f;
    private int foodTimer;
    private int prevFoodLevel = 20;

    public void addExhaustion(float exhaustion) {
        this.foodExhaustionLevel = Math.min(this.foodExhaustionLevel + exhaustion, 40.0f);
    }

    private void addStats(int foodLevelIn, float foodSaturationModifier) {
        this.foodLevel = Math.min(foodLevelIn + this.foodLevel, 20);
        this.foodSaturationLevel = Math.min(this.foodSaturationLevel + (float)foodLevelIn * foodSaturationModifier * 2.0f, (float)this.foodLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPrevFoodLevel() {
        return this.prevFoodLevel;
    }

    public boolean needFood() {
        return this.foodLevel < 20;
    }

    public void onFoodEaten(ItemFood food, ItemStack itemstack) {
        this.addStats(food.func_150905_g(itemstack), food.func_150906_h(itemstack));
    }

    public void onUpdate(EntityNPCInterface npc) {
        EnumDifficulty enumdifficulty = npc.field_70170_p.func_175659_aa();
        this.prevFoodLevel = this.foodLevel;
        if (this.foodExhaustionLevel > 4.0f) {
            this.foodExhaustionLevel -= 4.0f;
            if (this.foodSaturationLevel > 0.0f) {
                this.foodSaturationLevel = Math.max(this.foodSaturationLevel - 1.0f, 0.0f);
            } else if (enumdifficulty != EnumDifficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if (npc.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration") && this.foodLevel >= 18 && npc.func_110143_aJ() > 0.0f && npc.func_110143_aJ() < npc.func_110138_aP()) {
            ++this.foodTimer;
            if (this.foodTimer >= 80) {
                npc.func_70691_i(1.0f);
                this.addExhaustion(3.0f);
                this.foodTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.foodTimer;
            if (this.foodTimer >= 80) {
                if (npc.func_110143_aJ() > 10.0f || enumdifficulty == EnumDifficulty.HARD || npc.func_110143_aJ() > 1.0f && enumdifficulty == EnumDifficulty.NORMAL) {
                    npc.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                this.foodTimer = 0;
            }
        } else {
            this.foodTimer = 0;
        }
    }

    public void readNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("foodLevel", 99)) {
            this.foodLevel = compound.func_74762_e("foodLevel");
            this.foodTimer = compound.func_74762_e("foodTickTimer");
            this.foodSaturationLevel = compound.func_74760_g("foodSaturationLevel");
            this.foodExhaustionLevel = compound.func_74760_g("foodExhaustionLevel");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setFoodLevel(int foodLevelIn) {
        this.foodLevel = foodLevelIn;
    }

    @SideOnly(value=Side.CLIENT)
    public void setFoodSaturationLevel(float foodSaturationLevelIn) {
        this.foodSaturationLevel = foodSaturationLevelIn;
    }

    public void writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("foodLevel", this.foodLevel);
        compound.func_74768_a("foodTickTimer", this.foodTimer);
        compound.func_74776_a("foodSaturationLevel", this.foodSaturationLevel);
        compound.func_74776_a("foodExhaustionLevel", this.foodExhaustionLevel);
    }
}

